%% Ozone
[ozonedata, ozoneinfo] = ARM_CDF_Import('E:\Google Drive\Projects\HI-SCALE SGP\Data\ARM_Data\ozone');

% Removing bad data.  less than 0, and the ten minutes after midnight and noon
ozonedata.o3(ozonedata.o3 < 0) = NaN;
ozonedata.o3(ozonedata.time <= 600) = NaN;
ozonedata.o3(ozonedata.time >= 43200 & ozonedata.time <= 43800) = NaN;

[ozonedata.avgtime, ozonedata.avgo3] = RollingAverage(ozonedata.realtime,ozonedata.o3,600);
ozonedata.avgo3filt = medfilt1(ozonedata.avgo3);

ozonedata.avgtime_cdt = datetime(datevec(ozonedata.avgtime) - [0,0,0,5,0,0]);


%% Sulfer dioxide
[so2data, so2info] = ARM_CDF_Import('E:\Google Drive\Projects\HI-SCALE SGP\Data\ARM_Data\SO2');

so2_badbits = [1,2,3,16,17,18,19,22,23,24,25];

for so2bits_idx = 1:length(so2_badbits)
	so2data.so2(bitget(so2data.qc_so2,ones(size(so2data.qc_so2)).*so2_badbits(so2bits_idx)) == 1) = NaN;
	
end

[so2data.avgtime,so2data.avgso2] = RollingAverage(so2data.realtime,so2data.so2,600);
so2data.filtavgso2 = medfilt1(so2data.avgso2);

so2data.avgtime_cdt = datetime(datevec(so2data.avgtime) - [0,0,0,5,0,0]);


%% Carbon Monoxide and Nitrous Oxide
[codata, coinfo] = ARM_CDF_Import('E:\Google Drive\Projects\HI-SCALE SGP\Data\ARM_Data\CO');

% co_badbits = [1,2,3,18];
co_badbits = [1:12,18];

for cobits_idx = 1:length(co_badbits)
	codata.co_dry(bitget(codata.qc_co_dry, ones(size(codata.qc_co_dry)) .* co_badbits(cobits_idx)) == 1) = NaN;
	codata.n2o_dry(bitget(codata.qc_n2o_dry, ones(size(codata.qc_n2o_dry)) .* co_badbits(cobits_idx)) == 1) = NaN;
	
end

codata.n2o_dry(codata.time < 900) = NaN;

[codata.avgtime,codata.avgco] = RollingAverage(codata